﻿using UnityEngine;
using System.Collections;

public class PlayerScript : MonoBehaviour
{
    public Vector2 relativeAmmoPosition;
    public Vector2 relativeAmmoSize;
    public Vector4 relativeFireButton;
    public Vector4 relativeForceButton;
    public float relativeAmmoSpacing;
    public int maxAmmoCount;
    public static int ammoCount;
    public Texture2D ammoTexture;
    public Texture2D fireTexture;
    public Texture2D forceTexture;
    public float minFireForce;
    public float maxFireForce;
    public float currentForce;
    public float forceIncrement;
    public Transform bulletPrefab;
    public Transform turretPipe;
    private GUIStyle buttonStyle;
    private Rect fireButtonRect;
    private Rect forceButtonRect;
    private float angle;
    public AudioClip fireClip;
    public AudioClip forceClip;

    // Use this for initialization
	void Start ()
	{
	    PlayerScript.ammoCount = maxAmmoCount;
	    buttonStyle = new GUIStyle();
	    currentForce = minFireForce;
	    angle = turretPipe.eulerAngles.z;
	}
	
	// Update is called once per frame
	void FixedUpdate ()
	{
	    bool touching = false;
	    Vector2 touchPos = new Vector2(0,0);
        Vector2 invertedTouchPos = new Vector2(0, 0);

	    if (Application.platform == RuntimePlatform.Android)
	    {
            if (Input.touches[0].phase == TouchPhase.Moved || Input.touches[0].phase == TouchPhase.Began)
	        {
	            touching = true;
	        }
	        touchPos = Input.touches[0].position;
            invertedTouchPos = new Vector2(touchPos.x, Screen.height -touchPos.y);

	    }
	    else
	    {
	        touching = Input.GetMouseButton(0);
            invertedTouchPos = new Vector2(Input.mousePosition.x, Screen.height-Input.mousePosition.y);
	        touchPos = Input.mousePosition;
	    }
        if (touching && !fireButtonRect.Contains(invertedTouchPos))
        {
            RaycastHit2D hit = Physics2D.Raycast(Camera.main.ScreenToWorldPoint(touchPos), Vector2.zero);
            if(hit.collider != null)
            {
                Debug.Log ("Target Position: " + hit.collider.gameObject.transform.position);
                var hit2D =  new Vector2(hit.point.x- turretPipe.position.x, hit.point.y- turretPipe.position.y);
                angle = Vector2.Angle(hit2D, new Vector2(1, 0));
                turretPipe.eulerAngles = Vector3.Slerp(turretPipe.eulerAngles, new Vector3(0, 0, angle), Time.fixedDeltaTime);
            }
        }
       
	}

    void TryFire()
    {
        if(ammoCount > 0)
        {
            AudioSource.PlayClipAtPoint(fireClip,transform.position);
            Transform bullet = Instantiate(bulletPrefab, turretPipe.position, turretPipe.rotation) as Transform;
            var dir = new Vector2(Mathf.Cos(Mathf.Deg2Rad * turretPipe.eulerAngles.z),
                Mathf.Sin(Mathf.Deg2Rad * turretPipe.eulerAngles.z));
            bullet.GetComponent<Rigidbody2D>().AddForceAtPosition(dir * currentForce, new Vector2(-0.1f, 0.0f), ForceMode2D.Force);
            currentForce = minFireForce;
            
        }
    }

    void OnGUI()
    {
       
        for (int i = 0; i < ammoCount; i++)
        {
            var texRect = new Rect((relativeAmmoPosition.x + i*relativeAmmoSpacing)*Screen.width,
                            relativeAmmoPosition.y*Screen.height,relativeAmmoSize.x*Screen.width,
                            relativeAmmoSize.y*Screen.height);

            GUI.DrawTexture(texRect,ammoTexture);
        }

        fireButtonRect = new Rect(relativeFireButton.x * Screen.width - (relativeFireButton.z * Screen.width * currentForce / maxFireForce) / 2.0f,
            relativeFireButton.y * Screen.height - (relativeFireButton.w * Screen.height * currentForce / maxFireForce) / 2.0f,
          relativeFireButton.z * Screen.width * currentForce / maxFireForce, relativeFireButton.w * Screen.height * currentForce / maxFireForce);
       
        var flippedMousePos = new Vector2(Input.mousePosition.x, Screen.height - Input.mousePosition.y);
        if (fireButtonRect.Contains(flippedMousePos) && Input.GetMouseButton(0))//(GUI.RepeatButton(forceButtonRect, "", buttonStyle))
        {
            //AudioSource.PlayClipAtPoint(forceClip, transform.position);
            currentForce += forceIncrement;
            if (currentForce >= maxFireForce)
                currentForce = maxFireForce;
        }
       
        GUI.DrawTexture(fireButtonRect, fireTexture, ScaleMode.StretchToFill);
        if (GUI.Button(fireButtonRect, "", buttonStyle))
        {
            TryFire();
        }


    }
}
